//================================================================================
// MSMTLGameInfo.
//================================================================================
class MSMTLGameInfo extends MTLGameInfo;

event PlayerPawn Login (string Portal, string Z56, out string Error, Class<PlayerPawn> SpawnClass)
{
	local string Z68;
	local string Z69;
	local DeusExPlayer Player;
	local NavigationPoint StartSpot;
	local byte InTeam;
	local DumpLocation dump;
	local int Z6A;

	SpawnClass=DefaultPlayerClass;
	Z68=ParseOption(Z56,"Class");
	Z6A=InStr(Z68,".");
	if ( Z6A != -1 )
	{
		Z69=Mid(Z68,Z6A + 1);
		Z68=Left(Z68,Z6A);
	} else {
		Z69=Z68;
		Z68="";
	}
	if ( (Z69 ~= "MPNSF") || (Z69 ~= "MSMTLNSF") )
	{
		SpawnClass=Class'MSMTLNSF';
	} else {
		if ( (Z69 ~= "MPUNATCO") || (Z69 ~= "MSMTLUNATCO") )
		{
			SpawnClass=Class'MSMTLUNATCO';
		} else {
			if ( (Z69 ~= "MPMJ12") || (Z69 ~= "MTLMJ12") )
			{
				SpawnClass=Class'MSMTLUNATCO';
			}
		}
	}
	ChangeOption(Z56,"Class",string(SpawnClass));
	Player=DeusExPlayer(Super(GameInfo).Login(Portal,Z56,Error,SpawnClass));
	if ( Player != None )
	{
		Player.UpdateURL("Class",string(SpawnClass),True);
		Player.SaveConfig();
	}
	if ( (Player != None) &&  !HasOption(Z56,string('LoadGame')) )
	{
		Player.ResetPlayerToDefaults();
		dump=Player.CreateDumpLocationObject();
		if ( (dump != None) && dump.HasLocationBeenSaved() )
		{
			dump.LoadLocation();
			Player.Pause();
			Player.SetLocation(dump.currentDumpLocation.Location);
			Player.SetRotation(dump.currentDumpLocation.ViewRotation);
			Player.ViewRotation=dump.currentDumpLocation.ViewRotation;
			Player.ClientSetRotation(dump.currentDumpLocation.ViewRotation);
			CriticalDelete(dump);
		} else {
			InTeam=GetIntOption(Z56,"Team",0);
			if ( Level.NetMode == 0 )
			{
				StartSpot=FindPlayerStart(None,InTeam,Portal);
			} else {
				StartSpot=FindPlayerStart(Player,InTeam,Portal);
			}
			Player.SetLocation(StartSpot.Location);
			Player.SetRotation(StartSpot.Rotation);
			Player.ViewRotation=StartSpot.Rotation;
			Player.ClientSetRotation(Player.Rotation);
		}
	}
	return Player;
}

//
// Return the 'best' player start for this player to start from.
// Re-implement for each game type.
//
function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string incomingName )
{
	local PlayerStart Dest;
	local Teleporter Tel;
	
	local PathNode PN;

	if (Level.Netmode == NM_Standalone) return Super.FindPlayerStart(Player, InTeam, incomingName);
	
	//NEW CODE FOR ANTI FRAG!
	//foreach AllActors( class 'PlayerStart', Dest )
	//{
	Dest = PlayerStart(ObtainRandom(class'PlayerStart'));
	return Dest; //HACK! We now confirm profiles!
	if (Dest != None)
	{
	 PN = FindClosestNode(Dest);
	 
	 if (PN != None)
	  return PN;
	}
	//}
	
	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;
	foreach AllActors( class 'PlayerStart', Dest )
		if( Dest.bSinglePlayerStart && Dest.bEnabled )
			return Dest;

	// if none, check for any that aren't enabled
	log("WARNING: All single player starts were disabled - picking one anyway!");
	foreach AllActors( class 'PlayerStart', Dest )
		if( Dest.bSinglePlayerStart )
			return Dest;
	log( "No single player start found" );
	return None;
}

//Supports up to 128 scale!
function Actor ObtainRandom(class<Actor> Act)
{
 local Actor A;
 local int Count;
 local Actor TA[128];
 local SiegeSpawnPoint SP;
 
 forEach AllActors(Act, A)
 {
  if (A != None)
  {
   SP = SiegeSpawnPoint(A);
   
   if (SP == None)
   {
    TA[Count] = A;
    Count++;
   }
   else if (SP.MyTag ~= "")
   {
    TA[Count] = A;
    Count++;
   }
  }
 }
 
 return TA[Rand(Count)];
}


function PathNode FindClosestNode(PlayerStart P)
{
	local PathNode Nodes, BestNode;
	local float BestDist;
	local DeusExPlayer CheckP;
	local int j;
	
	local Teleporter TP;
	local MapExit ME;
	
	if (P == None) return None;
	
	BestDist = 99999;
	
	forEach AllActors(class'PathNode', Nodes)
	{
	 if (VSize(P.Location - Nodes.Location) < BestDist)
	 {
	  j = 0;
	  forEach RadiusActors(class'DeusExPlayer', CheckP, 40, Nodes.Location)
	   if (CheckP != None && CheckP != P) j++;
	  
	  forEach RadiusActors(class'Teleporter', TP, 80, P.Location)
	   j++;

	  forEach RadiusActors(class'MapExit', ME, 80, P.Location)
	   j++;
	  
	  if (j == 0)
	  {
	   BestNode = Nodes;
	   BestDist = VSize(P.Location - Nodes.Location);
	  }
	 }
	}
	
	if (BestNode != None) return BestNode;
	
	return None;
}

defaultproperties
{
    DefaultPlayerClass=Class'MSMTLUNATCO'
    GameReplicationInfoClass=Class'MTLGRI'
}
